/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.guice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.io.IOException;
import java.util.LinkedList;
import technology.rocketjump.undermount.assets.FloorDictionary;
import technology.rocketjump.undermount.environment.SunlightCalculator;
import technology.rocketjump.undermount.environment.model.SunlightPhase;

public class SunlightCalculatorProvider
implements Provider<SunlightCalculator> {
    @Override
    public SunlightCalculator get() {
        try {
            FileHandle sunlightJsonFile = Gdx.files.internal("assets/environment/sunlight.json");
            JSONArray jsonArray = JSON.parseArray(sunlightJsonFile.readString());
            LinkedList<SunlightPhase> sunlightPhaseList = new LinkedList<SunlightPhase>();
            ObjectMapper objectMapper = new ObjectMapper();
            for (int index = 0; index < jsonArray.size(); ++index) {
                SunlightPhase sunlightPhase = objectMapper.readValue(jsonArray.getJSONObject(index).toString(), SunlightPhase.class);
                sunlightPhaseList.add(sunlightPhase);
            }
            return new SunlightCalculator(sunlightPhaseList);
        }
        catch (IOException e) {
            throw new ProvisionException("Failed to createHumanoid " + FloorDictionary.class.getSimpleName(), e);
        }
    }
}

